/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** Contact: Nokia Corporation (qt-info@nokia.com)
**
** This file is part of the documentation of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial Usage
** Licensees holding valid Qt Commercial licenses may use this file in
** accordance with the Qt Commercial License Agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and Nokia.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain
** additional rights. These rights are described in the Nokia Qt LGPL
** Exception version 1.0, included in the file LGPL_EXCEPTION.txt in this
** package.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3.0 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU General Public License version 3.0 requirements will be
** met: http://www.gnu.org/copyleft/gpl.html.
**
** If you are unsure which license is appropriate for your use, please
** contact the sales department at http://www.qtsoftware.com/contact.
** $QT_END_LICENSE$
**
****************************************************************************/

#include <QFile>
#include <QTextStream>

static void process_line(const QByteArray &)
{
}

static void process_line(const QString &)
{
}

static void noStream_snippet()
{
//! [0]
    file = QFile("in.txt")
    if not file.open(QIODevice.ReadOnly | QIODevice.Text):
        return

    while not file.atEnd():
        line = file.readLine() # A QByteArray
        process_line(line)
//! [0]
}

static void readTextStream_snippet()
{
//! [1]
    file = QFile("in.txt")
    if not file.open(QIODevice.ReadOnly | QIODevice.Text):
        return

    in = QTextStream(file)
    while not in.atEnd():
        line = in.readLine() # A QByteArray
        process_line(line)
//! [1]
}

static void writeTextStream_snippet()
{
//! [2]
    file = QFile("out.txt")
    if not file.open(QIODevice.WriteOnly | QIODevice.Text):
        return

    out = QTextStream(file)
    out << "The magic number is: " << 49 << "\n"
//! [2]
}

static void writeTextStream_snippet()
{
    QFile file("out.dat");
    if (!file.open(QIODevice.WriteOnly))
        return;

    QDataStream out(&file);
    out << "The magic number is: " << 49 << "\n";
}

static void readRegularEmptyFile_snippet()
{
//! [3]
    file = QFile("/proc/modules")
    if not file.open(QIODevice.ReadOnly | QIODevice.Text):
        return

    in = QTextStream(file)
    line = in.readLine()
    while not line.isNull():
        process_line(line)
        line = in.readLine()
//! [3]
}

int main()
{
    lineByLine_snippet();
    writeStream_snippet();
}
